/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.data.codec.requirement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.momosoftworks.coldsweat.data.codec.requirement.BlockRequirement;
import com.momosoftworks.coldsweat.data.codec.requirement.FluidRequirement;
import com.momosoftworks.coldsweat.data.codec.util.IntegerBounds;
import com.momosoftworks.coldsweat.util.serialization.ConfigHelper;
import com.momosoftworks.coldsweat.util.world.WorldHelper;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.phys.Vec3;

public record LocationRequirement(Optional<Integer> x, Optional<Integer> y, Optional<Integer> z, Optional<Either<TagKey<Biome>, ResourceKey<Biome>>> biome, Optional<Either<TagKey<Structure>, ResourceKey<Structure>>> structure, Optional<Either<TagKey<Level>, ResourceKey<Level>>> dimension, Optional<IntegerBounds> light, Optional<BlockRequirement> block, Optional<FluidRequirement> fluid) {
    public static final Codec<LocationRequirement> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.optionalFieldOf("x").forGetter(location -> location.x), (App)Codec.INT.optionalFieldOf("y").forGetter(location -> location.y), (App)Codec.INT.optionalFieldOf("z").forGetter(location -> location.z), (App)ConfigHelper.tagOrResourceKeyCodec(Registry.f_122885_).optionalFieldOf("biome").forGetter(location -> location.biome), (App)ConfigHelper.tagOrResourceKeyCodec(Registry.f_235725_).optionalFieldOf("structure").forGetter(location -> location.structure), (App)ConfigHelper.tagOrResourceKeyCodec(Registry.f_122819_).optionalFieldOf("dimension").forGetter(location -> location.dimension), (App)IntegerBounds.CODEC.optionalFieldOf("light").forGetter(location -> location.light), (App)BlockRequirement.CODEC.optionalFieldOf("block").forGetter(location -> location.block), (App)FluidRequirement.CODEC.optionalFieldOf("fluid").forGetter(location -> location.fluid)).apply((Applicative)instance, LocationRequirement::new));

    public boolean test(Level level, Vec3 pos) {
        return this.test(level, new BlockPos(pos));
    }

    public boolean test(Level level, BlockPos origin) {
        int light;
        BlockPos.MutableBlockPos pos = origin.m_122032_();
        this.x.ifPresent(x -> pos.m_122184_(x.intValue(), 0, 0));
        this.y.ifPresent(y -> pos.m_122184_(0, y.intValue(), 0));
        this.z.ifPresent(z -> pos.m_122184_(0, 0, z.intValue()));
        if (this.dimension.isPresent() && !((Boolean)this.dimension.get().map(tag -> level.m_204156_().m_203373_(tag.f_203868_()), key -> level.m_46472_().equals(key))).booleanValue()) {
            return false;
        }
        if (this.biome.isPresent() && !((Boolean)this.biome.get().map(tag -> level.m_7062_().m_204216_((BlockPos)pos).m_203656_(tag), key -> level.m_7062_().m_204216_((BlockPos)pos).m_203565_(key))).booleanValue()) {
            return false;
        }
        if (this.structure.isPresent()) {
            StructureManager structureManager = WorldHelper.getServerLevel(level).m_215010_();
            StructureStart structureStart = (StructureStart)this.structure.get().map(tag -> structureManager.m_220491_((BlockPos)pos, tag), key -> structureManager.m_220488_((BlockPos)pos, key));
            if (structureStart == null || structureStart == StructureStart.f_73561_) {
                return false;
            }
        }
        if (this.light.isPresent() && ((light = level.m_46803_((BlockPos)pos)) < this.light.get().min() || light > this.light.get().max())) {
            return false;
        }
        if (this.block.isPresent() && !this.block.get().test(level, (BlockPos)pos)) {
            return false;
        }
        return !this.fluid.isPresent() || this.fluid.get().test(level, (BlockPos)pos);
    }

    public CompoundTag serialize() {
        return (CompoundTag)CODEC.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)this).result().orElseGet(CompoundTag::new);
    }

    public static LocationRequirement deserialize(CompoundTag tag) {
        return (LocationRequirement)((Pair)CODEC.decode((DynamicOps)NbtOps.f_128958_, (Object)tag).result().orElseThrow(() -> new IllegalArgumentException("Could not deserialize LocationRequirement"))).getFirst();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        LocationRequirement that = (LocationRequirement)obj;
        return this.x.equals(that.x) && this.y.equals(that.y) && this.z.equals(that.z) && this.biome.equals(that.biome) && this.structure.equals(that.structure) && this.dimension.equals(that.dimension) && this.light.equals(that.light) && this.block.equals(that.block) && this.fluid.equals(that.fluid);
    }

    @Override
    public String toString() {
        return CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this).result().map(Object::toString).orElse("serialize_failed");
    }
}

